/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplENSConflictingContent extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer Vermerke des Abfallerzeugers, wenn IndicatorMitBB nicht true.
     */
    private static final String XPATH_ERZ_VERMERKE = "(/descendant::en:IndicatorMitBB[last()]='false' "
            + "or /descendant::en:IndicatorMitBB[last()]=0) "
            + "and count(/descendant::en:Abfallerzeugervermerke) > 0";

    /**
     * XPath fuer Erzeuger im SN.
     */
    private static final String XPATH_SN_ERZEUGER = "(/descendant::en:IndicatorEN[last()]='false' "
            + "or /descendant::en:IndicatorEN[last()]=0) "
            + "and count(/descendant::en:Abfallherkunft[last()]/en:Erzeuger) > 0";

    /**
     * XPath fuer Sammler im EN.
     */
    private static final String XPATH_EN_SAMMLER = "(/descendant::en:IndicatorEN[last()]='true' "
            + "or /descendant::en:IndicatorEN[last()]=1) "
            + "and count(/descendant::en:Abfallherkunft[last()]/en:Sammler) > 0";

    /**
     * XPath fuer abweichende Abfallart VE.
     */
    private static final String XPATH_ABFALLART_DB =
            "(count(/descendant::en:Abfallschluessel[ancestor::en:Deckblatt]) > 0 "
            + "and count(/descendant::en:Abfallschluessel[ancestor::en:VE]) > 0 "
            + "and (not(/descendant::en:Abfallschluessel[ancestor::en:Deckblatt]=/descendant::en:Abfallschluessel[ancestor::en:VE]))) "
            + "or (count(/descendant::en:Abfallbezeichnung[ancestor::en:Deckblatt]) > 0 "
            + "and count(/descendant::en:Abfallbezeichnung[ancestor::en:VE]) > 0 "
            + "and (not(/descendant::en:Abfallbezeichnung[ancestor::en:Deckblatt]=/descendant::en:Abfallbezeichnung[ancestor::en:VE])))";

    /**
     * XPath fuer abweichende Abfallart AE.
     */
    private static final String XPATH_ABFALLART_AE =
            "(count(/descendant::en:Abfallschluessel[ancestor::en:VE]) > 0 "
            + "and count(/descendant::en:Abfallschluessel[ancestor::en:AE]) > 0 "
            + "and (not(/descendant::en:Abfallschluessel[ancestor::en:VE]=/descendant::en:Abfallschluessel[ancestor::en:AE]))) "
            + "or (count(/descendant::en:Abfallbezeichnung[ancestor::en:VE]) > 0 "
            + "and count(/descendant::en:Abfallbezeichnung[ancestor::en:AE]) > 0 "
            + "and (not(/descendant::en:Abfallbezeichnung[ancestor::en:VE]=/descendant::en:Abfallbezeichnung[ancestor::en:AE])))";

    /**
     * XPath fuer BB ohne IndicatorMitBB.
     */
    private static final String XPATH_BB = "(/descendant::en:IndicatorMitBB[last()]='false' "
            + "or /descendant::en:IndicatorMitBB[last()]=0) "
            + "and count(/descendant::en:BB) > 0";

    /**
     * XPath fuer Anordnung mit IndicatorMitBB.
     */
    private static final String XPATH_ANO = "(/descendant::en:IndicatorMitBB[last()]='true' "
            + "or /descendant::en:IndicatorMitBB[last()]=1) "
            + "and count(/descendant::en:Anordnung) > 0";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplENSConflictingContent(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        try {
            if (XPathFassade.getInstance().evalBool(
                    bmuDok.getDocument().getDocumentElement(), XPATH_ERZ_VERMERKE)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, "Vermerke des Abfallerzeugers im Deckblatt: nur zulssig, wenn 'IndicatorMitBB' auf true gesetzt ist."));
            }
            if (XPathFassade.getInstance().evalBool(
                    bmuDok.getDocument().getDocumentElement(), XPATH_SN_ERZEUGER)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, "'Erzeuger': nur zulssig, wenn der ENS ein EN ist."));
            }
            if (XPathFassade.getInstance().evalBool(
                    bmuDok.getDocument().getDocumentElement(), XPATH_EN_SAMMLER)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, "'Sammler': nur zulssig, wenn der ENS ein SN ist."));
            }
            if (XPathFassade.getInstance().evalBool(
                    bmuDok.getDocument().getDocumentElement(), XPATH_ABFALLART_DB)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, "Die Angaben zur Abfallart in der VE widersprechen den Angaben im Deckblatt."));
            }
            if (XPathFassade.getInstance().evalBool(
                    bmuDok.getDocument().getDocumentElement(), XPATH_ABFALLART_AE)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, "Die Angaben zur Abfallart in der VE widersprechen den Angaben in der AE."));
            }
            if (XPathFassade.getInstance().evalBool(
                    bmuDok.getDocument().getDocumentElement(), XPATH_BB)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, "'BB': nur zulssig, wenn der 'IndicatorMitBB' in der obersten Sicht auf true gesetzt ist."));
            }
            if (XPathFassade.getInstance().evalBool(
                    bmuDok.getDocument().getDocumentElement(), XPATH_ANO)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, "'Anordnung': nur zulssig, wenn der 'IndicatorMitBB' in der obersten Sicht auf false gesetzt ist."));
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath fuer Vermerke des Abfallerzeugers, wenn IndicatorMitBB nicht true ist: ");
        builder.append(XPATH_ERZ_VERMERKE);
        builder.append(RuleImpl.NL);
        builder.append("XPath fuer Erzeuger im SN: ");
        builder.append(XPATH_SN_ERZEUGER);
        builder.append(RuleImpl.NL);
        builder.append("XPath fuer Sammler im EN: ");
        builder.append(XPATH_EN_SAMMLER);
        builder.append(RuleImpl.NL);
        builder.append("XPath fuer abweichende Abfallart im Deckblatt: ");
        builder.append(XPATH_ABFALLART_DB);
        builder.append(RuleImpl.NL);
        builder.append("XPath fuer abweichende Abfallart in der AE: ");
        builder.append(XPATH_ABFALLART_AE);
        builder.append(RuleImpl.NL);
        builder.append("XPath fuer BB ohne IndicatorMitBB: ");
        builder.append(XPATH_BB);
        builder.append(RuleImpl.NL);
        builder.append("XPath fuer Anordnung mit IndicatorMitBB: ");
        builder.append(XPATH_ANO);
        return builder.toString();
    }

}
