/**
q * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2015-11-02 13:38:36 +0100 (Mo, 02 Nov 2015) $ $Rev: 1406 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleFactory;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.config.schema.fxs.FXSSchemaValidator.ValidationErrorHandler;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * Prft, ob an den spezifizierten Positionen ein Element mit dem erwarteten
 * Namen und dem entsprechenden Namespace-URI existiert. Die Substruktur wird
 * gegen das entsprechende Schema geprft.
 * 
 * @author srossbroich
 */
public final class RuleImplFXSSchema extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory.getLog(RuleImplFXSSchema.class);

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplFXSSchema(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> validateSubDoc(Node node, int index, String id)
            throws BMUException {
        LOGGER.debug("Validating sub-structure with id: " + id);
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = XmlUtils.newDocument(true);
        Node importedNode = doc.importNode(node, true);
        doc.appendChild(importedNode);
        // Wegen xsi:type Attribut in ECDSA-Signatur..
        doc.normalizeDocument();
        ValidationErrorHandler handler = RuleFactory.getInstance().getFXSSchemaValidator().validate(doc.getDocumentElement());
        if (handler != null) {
            List<SAXParseException> errorList = handler.getErrorList();
            if (!errorList.isEmpty()) {
                for (SAXParseException saxParseException : errorList) {
                    ruleResultList
                            .add(new RuleResultImpl(this.getRuleDef(), index++,
                                    id + ", " + saxParseException.getMessage()));
                }
            }
        } else {
            LOGGER.error("Error validating document");
            throw new BMUException("Error validating document");
        }
        return ruleResultList;
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        List<FXSDokument> fxsList = bmuDok.getMessageType().getFXSDokumentList();
    	try {
    		for (FXSDokument fxsDokument : fxsList) {
    	        Element elem = fxsDokument.getRootElement();
	        	String id = XPathFassade.getInstance().evaluate(elem, "parent::*/@lib:id");
	        	List<RuleResult> rrl = validateSubDoc(elem, index, id);
	        	index += rrl.size();
	        	ruleResultList.addAll(rrl);
            }
        } catch (XPathExpressionException e) {
        	throw new BMUException("Fehler beim Prfen", e);
		}
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        return builder.toString();
    }
}
