/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 10:24:11 +0200 (Fr, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;

/**
 * @author candersen
 * 
 */
public final class RuleImplSignatureEIDAS extends RuleImpl {

    private static final long serialVersionUID = 1L;
    
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureEIDAS.class);

    private static final String TECHDOC = "Prft die Signaturen "
            + "im Dokument auf die Verwendung von Elementen nach der eIDAS Verordnung";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureEIDAS(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        List<SignatureVerificationResult> svrList = bmuDok.getMessageType().getSignatureVerificationResultList();
        int index = 1;
        for (SignatureVerificationResult svr : svrList) {
            if (svr.isEnabled(getRuleDef()) && svr.isEIDAS()) {
                String msg = "Signatur mit Elementen nach der eIDAS Verordnung, ID: "
                        + svr.getSignatureID();
                LOGGER.debug(msg);
                ruleResultList
                        .add(new RuleResultImpl(this
                                .getRuleDef(), index++,
                                svr.getSignatureID()));
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return TECHDOC;
    }

}
