/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 10:24:11 +0200 (Fr, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xmlsec.XmlSecFassade;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureXPathFixed extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory
            .getLog(RuleImplSignatureXPathFixed.class);

    /**
     * XPath fuer ds:Signature.
     */
    private static final String XPATH_SIGNATURE = "/descendant::ds:Signature[@Id]";

    /**
     * XPath fuer den intersect-XPath.
     */
    private static final String XPATH_SIGXPATH_INTERSECT = "descendant::dsf:XPath[@Filter='intersect']";

    /**
     * XPath fuer den intersect-XPath.
     */
    private static final String XPATH_SIGXPATH_SUBTRACT = "descendant::dsf:XPath[@Filter='subtract']";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureXPathFixed(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        int index = 1;
        try {
            NodeList nlSig = xpf.evaluateNodeList(bmuDok.getDocument(), XPATH_SIGNATURE);

            for (int i = 0; i < nlSig.getLength(); i++) {
                Node sigNode = nlSig.item(i);
                if (sigNode instanceof Element) {
                    Element sigElem = (Element) sigNode;
                    String sigID = sigElem.getAttribute("Id");
                    SignatureVerificationResult svr = bmuDok.getMessageType()
                            .getSignatureVerificationResult(sigID);

                    if (svr != null && svr.isEnabled(getRuleDef())) {
                        NodeList nl = xpf.evaluateNodeList(sigElem,
                                XPATH_SIGXPATH_INTERSECT);
                        if (nl.getLength() == 1) {
                            Element xPathNode = (Element) nl.item(0);
                            String xPath = xPathNode.getTextContent();
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Checking Intersect-XPath of Signature with ID '"
                                        + sigID + "': " + xPath);
                            }
                            if (!XmlSecFassade.XPATH_INTERSECT.equals(xPath)) {
                                ruleResultList.add(new RuleResultImpl(
                                        getRuleDef(), index++, sigID));
                            }
                        } else {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Missing or multiple Intersect-XPath in Signature with ID '"
                                        + sigID);
                            }
                            ruleResultList.add(new RuleResultImpl(
                                    getRuleDef(), index++, sigID));
                        }
                        nl = xpf.evaluateNodeList(
                                sigElem, XPATH_SIGXPATH_SUBTRACT);
                        if (nl.getLength() == 1) {
                            Element xPathNode = (Element) nl.item(0);
                            String xPath = xPathNode.getTextContent();
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Checking Subtract-XPath of Signature with ID '"
                                        + sigID + "': " + xPath);
                            }
                            if (!XmlSecFassade.XPATH_SUBTRACT_EXCLUDE_PREVIOUS_SIG
                                    .equals(xPath)
                                    && !XmlSecFassade.XPATH_SUBTRACT_INCLUDE_PREVIOUS_SIG
                                            .equals(xPath)) {
                                ruleResultList.add(new RuleResultImpl(
                                        getRuleDef(), index++, sigID));
                            }
                        } else {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Missing or multiple Subtract-XPath in Signature with ID '"
                                        + sigID);
                            }
                            ruleResultList.add(new RuleResultImpl(
                                    getRuleDef(), index++, sigID));
                        }
                    }
                }
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes fr die Ermittlung der zu prfenden Inhalte: ");
        builder.append(XPATH_SIGXPATH_INTERSECT);
        builder.append(", ");
        builder.append(XPATH_SIGXPATH_SUBTRACT);
        builder.append(", die ermittelten XPath-Audrcke mssen den Vorgaben der BMU-Schnittstelle entsprechen.");
        return builder.toString();
    }

}
