/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2025-10-16 12:46:25 +0000 (Thu, 16 Oct 2025) $ $Rev: 1874 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.schema;

import javax.xml.namespace.NamespaceContext;

import de.consist.bmu.rule.xpath.GenericNamespaceContext;

/**
 * TODO Wenn diese Klasse von BMUMessageType zurckgegeben wird, sollte sie auch
 * im Javadoc erscheinen.
 * 
 * @author srossbroich
 * 
 */
public enum Namespace {
    /** lib-namespace. */
    TypenBibliothek("uri:BMU_Waste_Interface/Bibliothek", "lib"),
    /** cat-namespace. */
    Kataloge("uri:BMU_Waste_Interface/Kataloge", "cat"),
    /** msg-namespace. */
    Nachricht("uri:BMU_Waste_Interface/Message", "msg"),
    /** bgs-namespace. */
    Begleitschein("uri:BMU_Waste_Interface/BGS", "bgs"),
    /** en-namespace. */
    EN("uri:BMU_Waste_Interface/EN", "en"),
    /** ntz-namespace. */
    Notifizierung("uri:BMU_Waste_Interface/Ntz", "ntz"),
    /** reg-namespace. */
    Register("uri:BMU_Waste_Interface/Reg", "reg"),
    /** ags-namespace. */
    AGS("uri:BMU_Waste_Interface/AGS", "ags"),
    /** da-namespace. */
    DA("uri:BMU_Waste_Interface/DA", "da"),
    /** zks-namespace. */
    ZKS("uri:BMU_Waste_Interface/ZKS", "zks"),
    /** Service-Modul. */
    zert_pruef("uri:BMU_ServiceModul/zert_pruef", "zert_pruef"),
    /** EUDIN. */
    EUDINNotificationDocument("usr:EUDINNotificationDocument:2:1", "userrsm"),
    /** EUDIN. */
    EUDINWasteMovementDocument("usr:EUDINWasteMovementDocument:2:1", "userrsm"),
    /** EUDIN. */
    EUDINWasteTransportStatement("usr:EUDINWasteTransportStatement:2:1", "userrsm"),
    /** EUDIN. */
    EUDINCertificateOfWasteReceiptDocument("usr:EUDINCertificateOfWasteReceiptDocument:2:1", "userrsm"),
    /** EUDIN. */
    EUDINCertificateOfWasteRecoveryDisposalDocument("usr:EUDINCertificateOfWasteRecoveryDisposalDocument:2:1", "userrsm"),
    /** EUDIN. */
    EUDINConfirmationOfMessageReceipt("usr:EUDINConfirmationOfMessageReceipt:2:1", "userrsm"),
    /** EUDIN. */
    udt("urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2:1", "udt"),
    /** EUDIN. */
    qdt("urn:un:unece:uncefact:data:specification:QualifiedDataTypeSchemaModule:2:1", "qdt"),
    /** EUDIN. */
    ram("urn:un:unece:uncefact:data:specification:ReusableAggregateBusinessInformationEntitySchemaModule:2:1", "ram"),
    /** EUDIN. */
    userqdt("usr:QualifiedDataTypeSchemaModule:2:1", "userrsm"),
    /** EUDIN. */
    userram("usr:ReusableAggregateBusinessInformationEntitySchemaModule:2:1", "userram"),
    /** ds-namespace. */
    xmldsig("http://www.w3.org/2000/09/xmldsig#", "ds"),
    /** dsf-namespace. */
    xmldsig_filter2("http://www.w3.org/2002/06/xmldsig-filter2", "dsf"),
    /** xades-namespace. */
    xades("http://uri.etsi.org/01903/v1.3.2#", "xades"),
    /** osci-namespace. */
    osci("http://www.osci.de/2002/04/osci", "osci"),
    /** xmldsig-more-ecdsa namespace. */
    xmldsig_more("http://www.w3.org/2001/04/xmldsig-more#", "ecdsa"),
    /** xmldsig-1.1 namespace. */
    xmldsig11("http://www.w3.org/2009/xmldsig11#", "dsig11"),
    /** Anzeige und Erlaubnis namespace. */
    abfaev("uri:AnzeigeErlaubnis/AbfAEV", "abfaev"),
    /** Anzeige und Erlaubnis lib-namespace. */
    aevlib("uri:AnzeigeErlaubnis/Kopie_TypBibliothek", "aevlib"),
    /** Anzeige und Erlaubnis cat-namespace. */
    aevcat("uri:AnzeigeErlaubnis/Kopie_Kataloge", "aevcat"),
    /** Erzeuger-Stammdaten namespace. */
    erzst("uri:ErzeugerStammdaten/ErzStamm", "erzst"),
    /** Erzeuger-Stammdaten lib-namespace. */
    ezlib("uri:ErzeugerStammdaten/ErzStammTypBibliothek", "ezlib"),
    /** Erzeuger-Stammdaten cat-namespace. */
    ezcat("uri:ErzeugerStammdaten/ErzStammKataloge", "ezcat"),
    /** Entsorger-Stammdaten namespace. */
    entst("uri:EntsorgerStammdaten/EntStamm", "entst"),
    /** Entsorger-Stammdaten lib-namespace. */
    eslib("uri:EntsorgerStammdaten/EntStammTypBibliothek", "eslib"),
    /** Entsorger-Stammdaten cat-namespace. */
    escat("uri:EntsorgerStammdaten/EntStammKataloge", "escat"),
    /** Befoerderer-Stammdaten namespace. */
    befst("uri:BefoerdererStammdaten/BefStamm", "befst"),
    /** Makler-Stammdaten namespace. */
    makst("uri:MaklerStammdaten/MakStamm", "makst"),
    /** Betrieb-Stammdaten lib-namespace. */
    btrlib("uri:BetriebStammdaten/BtrStammTypBibliothek", "btrlib"),
    /** Betrieb-Stammdaten cat-namespace. */
    btrcat("uri:BetriebStammdaten/BtrStammKataloge", "btrcat"),
    // waste shipment guidelines 11
    wmsg("Waste-WG-2018-Message", "wmsg"),
    // string-latin 1.2
    dt("http://xoev.de/latinchars/dt", "dt"),
    // XML-Schema
    xs("http://www.w3.org/2001/XMLSchema", "xs"),
    // ServiceModul
    svc("urn:de:bmu:eanv:ServiceModul:0:4", "svc"),
    // Bereitstellungsportal
    anbport("uri:Bereitstellungsportal/AnBPortal", "anbport"),
    // Befreiungen und Verpflichtungen
    ebnur("uri:eBNuR/eBNuR", "eBNuR"),
    ebnurlib("uri:eBNuR/eBNuRlib", "eBNuRlib"),
    ebnurcat("uri:eBNuR/eBNuRcat", "eBNuRcat"),
    // Diwass
    DiWaSSTypenBibliothek("uri:BMU_Waste_Interface/DiWaSS", "wsr"),
    ;

    private String _uri;
    private String _prefix;
    private static GenericNamespaceContext _ctx;

    Namespace(String uri, String prefix) {
        _uri = uri;
        _prefix = prefix;
    }

    /**
     * @return String
     */
    public String getUri() {
        return _uri;
    }

    /**
     * @return String
     */
    public String getPrefix() {
        return _prefix;
    }

    /**
     * @return NamespaceContext
     */
    public static synchronized NamespaceContext getNamespaceContext() {
        if (_ctx == null) {
            _ctx = new GenericNamespaceContext();
            for (Namespace ns : Namespace.values()) {
                _ctx.setNamespace(ns._prefix, ns._uri);
            }
        }
        return _ctx;
    }
}
