/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2014-03-03 20:09:15 +0000 (Mon, 03 Mar 2014) $ $Rev: 1161 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.xpath;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.schema.Namespace;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

/**
 * Fassade um das XPath-API implementiert durch Xalan.
 * <P>
 * Dazu gedacht, das Dokument beliebig auswerten zu knnen.
 * 
 */
public final class XPathFassade {
	// private static final String TEXT_SELECTOR = "text()";

	private static XPathFassade _theInstance = new XPathFassade();
	private static final Log LOGGER = LogFactory.getLog(XPathFassade.class);
	private XPathFactory _xf = null;
	private NamespaceContext _ctx = null;

	private XPathFassade() {
		_xf = XPathFactory.newInstance();
		_ctx = Namespace.getNamespaceContext();
	}

	/**
	 * @return XPathFassade
	 */
	public static synchronized XPathFassade getInstance() {
		return XPathFassade._theInstance;
	}

	private Object evaluate(String expression, Element item, QName returnType) throws XPathExpressionException {
		XPath xp = _xf.newXPath();
		xp.setNamespaceContext(_ctx);
		Object result = null;
		Document ownerDoc = item.getOwnerDocument();
		synchronized (ownerDoc) {
			if (XPathFassade.LOGGER.isDebugEnabled()) {
				XPathFassade.LOGGER.debug("<evaluate> expression: '" + expression + "', context: '" + item.getNodeName() + "', returnType: '" + returnType
						+ "'");
			}
			result = xp.evaluate(expression, item, returnType);
			if (XPathFassade.LOGGER.isDebugEnabled()) {
				XPathFassade.LOGGER.debug("<evaluate> result: " + result);
			}
		}
		return result;
	}

	/**
	 * @param root
	 *            Element
	 * @param expression
	 *            String
	 * @return NodeList
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public NodeList evaluateNodeList(Element root, String expression) throws XPathExpressionException {
		return (NodeList) evaluate(expression, root, XPathConstants.NODESET);
	}

	/**
	 * @param doc
	 *            Document
	 * @param expression
	 *            String
	 * @return NodeList
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public NodeList evaluateNodeList(Document doc, String expression) throws XPathExpressionException {
		return evaluateNodeList(doc.getDocumentElement(), expression);
	}

	/**
	 * @param doc
	 *            Document
	 * @param expression
	 *            String
	 * @return Node
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public Node evaluateNode(Document doc, String expression) throws XPathExpressionException {
		return evaluateNode(doc.getDocumentElement(), expression);
	}

	/**
	 * @param root
	 *            Element
	 * @param expression
	 *            String
	 * @return Node
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public Node evaluateNode(Element root, String expression) throws XPathExpressionException {
		return (Node) evaluate(expression, root, XPathConstants.NODE);
	}

	/**
	 * @param doc
	 *            Document
	 * @param expression
	 *            String
	 * @return String
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public String evaluate(Document doc, String expression) throws XPathExpressionException {
		return evaluate(doc.getDocumentElement(), expression);
	}

	/**
	 * @param root
	 *            Element
	 * @param expression
	 *            String
	 * @return String
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public String evaluate(Element root, String expression) throws XPathExpressionException {
		return (String) evaluate(expression, root, XPathConstants.STRING);
	}

	/**
	 * @param elem
	 *            Element
	 * @param expression
	 *            String
	 * @return boolean
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public boolean evalBool(Element elem, String expression) throws XPathExpressionException {
		return (Boolean) evaluate(expression, elem, XPathConstants.BOOLEAN);
	}

	/**
	 * @param elem
	 *            Element
	 * @param expression
	 *            String
	 * @return double
	 * @throws XPathExpressionException
	 *             XPathExpressionException
	 */
	public double evalNumber(Element elem, String expression) throws XPathExpressionException {
		return (Double) evaluate(expression, elem, XPathConstants.NUMBER);
	}
}
