/*
 * Decompiled with CFR 0.152.
 */
package seccommerce.secsignerext;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import seccommerce.mobile.bo.CntReqStatusType;
import seccommerce.mobile.bo.ContactRequest;
import seccommerce.secsignerext.ag;
import seccommerce.secsignerext.aqy;
import seccommerce.secsignerext.b2n;
import seccommerce.secsignerext.b2p;
import seccommerce.secsignerext.b2q;
import seccommerce.secsignerext.b2s;
import seccommerce.secsignerext.b_p;
import seccommerce.secsignerext.bwz;
import seccommerce.secsignerext.bx5;
import seccommerce.secsignerext.bx7;
import seccommerce.secsignerext.byy;
import seccommerce.secsignerext.cb9;
import seccommerce.secsignerext.cc;
import seccommerce.secsignerext.cde;
import seccommerce.secsignerext.os;
import seccommerce.secsignerext.x0;
import seccommerce.user.bo.IdProfile;
import seccommerce.user.bo.VisibilityType;

@b2p(a=b2q.IDSERVER, b=b2s.REQUEST)
public class bx6
implements bx5 {
    @b2n
    private bwz a;
    @b2n
    private byy b;

    @Override
    public void a(@NotNull List<Long> list) throws aqy {
        Objects.requireNonNull(list, "acceptContactRequest: contactRequestIds must not be null");
        try {
            this.b.b(list);
        }
        catch (b_p b_p2) {
            throw new aqy("ContactRequestService: Could not accept contact request " + cc.a(list, ","), b_p2);
        }
    }

    @Override
    public void b(@NotNull List<Long> list) throws aqy {
        Objects.requireNonNull(list, "rejectContactRequest: contactRequestIds must not be null");
        try {
            this.b.c(list);
        }
        catch (b_p b_p2) {
            throw new aqy("ContactRequestService: Could not reject contact request " + cc.a(list, ","), b_p2);
        }
    }

    public void a(@NotNull Long l10, @NotNull Long l11, @NotNull IdProfile idProfile) throws aqy {
        Objects.requireNonNull(l10, "sendContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(idProfile, "Cannot sendContactRequest: recipient is null");
        if (VisibilityType.PRIVATE.equals(idProfile.getPrfVisibility())) {
            this.b(l10, l11, idProfile.getUserIdId());
            return;
        }
        this.a(l10, l11, idProfile.getUserIdId());
    }

    @Override
    public void a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqy {
        Objects.requireNonNull(l10, "sendContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot sendContactRequest: recipientUserIdId is null");
        this.a(l10, l11, l12, bx7.a);
    }

    public void b(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12) throws aqy {
        Objects.requireNonNull(l10, "sendHiddenContactRequest: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot sendHiddenContactRequest: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot sendHiddenContactRequest: recipientUserIdId is null");
        this.a(l10, l11, l12, bx7.b);
    }

    @NotNull
    public List<cb9> a(@NotNull Set<Long> set) throws aqy {
        List list;
        Objects.requireNonNull(set, "get: contactRequestIds must not be null");
        try {
            list = this.b.a(set);
        }
        catch (b_p b_p2) {
            throw new aqy("Error while trying to get contact request with id " + set, b_p2);
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return cde.a(list, cb9::new);
    }

    private final void a(@NotNull Long l10, @NotNull Long l11, @NotNull Long l12, @NotNull bx7 bx72) throws aqy {
        Objects.requireNonNull(l10, "send: orgId must not be null");
        Objects.requireNonNull(l11, "Cannot send contact request: requesterUserIdId is null");
        Objects.requireNonNull(l12, "Cannot send contact request: recipientUserIdId is null");
        Objects.requireNonNull(bx72, "Cannot send contact request: visibility is null");
        if (l11.equals(l12)) {
            throw new IllegalArgumentException("ContactRequestService Cannot create new contact request: userIdId " + l12 + " cannot be both requester and recipient");
        }
        if (this.b(l11, l12) != null) {
            os.f("ContactRequestService: Not sending a contact request from " + l11 + " to " + l12 + " because a request was already sent earlier.");
            return;
        }
        os.f("Sending contact request from userIdId " + l11 + " to userIdId " + l12);
        try {
            this.b.a(l10, l11, l12, CntReqStatusType.ah, bx72);
        }
        catch (b_p b_p2) {
            throw new aqy("Error while sending contact request from userIdId " + l11 + " to userIdId " + l12, b_p2);
        }
        os.g("Sending notification to user " + l12 + " about received contact request");
        this.a.a(new x0(l12, l10));
    }

    @Nullable
    public cb9 b(@NotNull Long l10, @NotNull Long l11) throws aqy {
        Objects.requireNonNull(l10, "Cannot findRequest: userIdIdA is null");
        Objects.requireNonNull(l11, "Cannot findRequest: userIdIdB is null");
        os.f("ContactRequestService: Searching if a contact request exists between " + l10 + " and " + l11);
        try {
            List<ContactRequest> list = this.b.a(l10, l11);
            if (list.isEmpty()) {
                os.f("ContactRequestService: Found no contact request between " + l10 + " and " + l11);
                return null;
            }
            if (list.size() > 1) {
                throw new aqy("Found " + list.size() + " ContactRequests from userIdId " + l10 + " to " + l11 + " in the database. Expected at most one");
            }
            os.f("ContactRequestService: Found contact request between " + l10 + " and " + l11 + ": " + list.get(0));
            return cde.a((ag)list.get(0), new cb9());
        }
        catch (b_p b_p2) {
            throw new aqy("Error while finding contact requests between userIdId " + l10 + " and userIdId " + l11, b_p2);
        }
    }

    @Override
    @NotNull
    public List<cb9> a(@NotNull Long l10) throws aqy {
        Objects.requireNonNull(l10, "getAllRequests: userIdId must not be null");
        os.f("ContactRequestService: Getting all contact requests userIdId " + l10 + " is part of");
        try {
            return cde.a(this.b.d(l10), cb9::new);
        }
        catch (b_p b_p2) {
            throw new aqy("ContactRequestService: Error while getting all contact requests of userIdId " + l10, b_p2);
        }
    }

    @Override
    @NotNull
    public List<cb9> b(@NotNull Long l10) throws aqy {
        Objects.requireNonNull(l10, "Cannot getAllAcceptedRequests: userIdId is null");
        os.f("ContactRequestService: Getting all accepted contact requests where userIdId " + l10 + " is a part of");
        try {
            return this.b.e(l10).stream().map(contactRequest -> cde.a(contactRequest, new cb9())).collect(Collectors.toList());
        }
        catch (b_p b_p2) {
            throw new aqy("Error while querying getAllAccepted", b_p2);
        }
    }

    @Override
    @NotNull
    public List<cb9> c(@NotNull Long l10) throws aqy {
        Objects.requireNonNull(l10, "getAllPendingRequestsForRecipient: userIdId must not be null");
        os.f("ContactRequestService: Getting all pending contact requests where userIdId " + l10 + " is recipient");
        try {
            return this.b.g(l10).stream().map(contactRequest -> cde.a(contactRequest, new cb9())).collect(Collectors.toList());
        }
        catch (b_p b_p2) {
            throw new aqy("Error while querying getAllPendingRequests", b_p2);
        }
    }

    @Override
    @NotNull
    public List<cb9> d(@NotNull Long l10) throws aqy {
        Objects.requireNonNull(l10, "getAllRejectedRequestsForRecipient: userIdId must not be null");
        os.f("ContactRequestService: Getting all rejected contact requests where userIdId " + l10 + " is recipient");
        try {
            return this.b.h(l10).stream().map(contactRequest -> cde.a(contactRequest, new cb9())).collect(Collectors.toList());
        }
        catch (b_p b_p2) {
            throw new aqy("Error while querying getAllPendingRequests", b_p2);
        }
    }

    @Override
    public void a(@NotNull Long l10, @NotNull Long l11) throws aqy {
        Objects.requireNonNull(l10, "deleteContactRequest: userIdIdA must not be null");
        Objects.requireNonNull(l11, "deleteContactRequest: userIdIdB must not be null");
        cb9 cb92 = this.b(l10, l11);
        if (cb92 == null) {
            throw new aqy("ContactRequestService: Cannot delete contact request: No request found between userIdId " + l10 + " and " + l11);
        }
        os.f("ContactRequestService: Deleting contact request " + cb92.a());
        try {
            this.b.f(cb92.a());
        }
        catch (b_p b_p2) {
            throw new aqy("ContactRequestService: Cannot delete contact request " + cb92.a(), b_p2);
        }
    }

    @Override
    public long e(@NotNull Long l10) throws aqy {
        Objects.requireNonNull(l10, "deleteAllContactRequestsOfUserIdId: userIdId must not be null");
        os.f("ContactRequestService: Deleting all contact requests where userIdId " + l10 + " is either requester or recipient");
        try {
            return this.b.c(l10);
        }
        catch (b_p b_p2) {
            throw new aqy("ContactRequestService: Cannot delete all contact requests of userIdId " + l10, b_p2);
        }
    }
}

