/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.def;

import de.consist.bmu.rule.BMUVersion;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleSetDef;
import de.consist.bmu.rule.def.RuleDefImpl;
import de.consist.bmu.rule.def.XmlBMUVersionAdapter;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="rulesetdef", propOrder={"_version", "_id", "_name", "_ruleDefRefOK", "_ruleDefRefError", "_ruleDefList"})
@XmlRootElement(name="Regelmenge")
public class RuleSetDefImpl
implements RuleSetDef {
    private static final Log LOGGER = LogFactory.getLog(RuleSetDefImpl.class);
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Version")
    @XmlJavaTypeAdapter(value=XmlBMUVersionAdapter.class)
    private BMUVersion _version;
    @XmlElement(name="Id")
    private String _id;
    @XmlElement(name="Name")
    private String _name;
    @XmlElement(name="Bezug_OK", type=RuleDefImpl.class)
    private RuleDef _ruleDefRefOK;
    @XmlElement(name="Bezug_Fehler", type=RuleDefImpl.class)
    private RuleDef _ruleDefRefError;
    @XmlElement(name="Regel")
    private List<RuleDef> _ruleDefList;

    public RuleSetDefImpl() {
    }

    public RuleSetDefImpl(String id, String name, RuleDef ruleDefRefOK, RuleDef ruleDefRefError, List<RuleDef> ruleDefList) {
        this._id = id;
        this._name = name;
        this.setRuleList(ruleDefList);
        this._ruleDefRefOK = ruleDefRefOK;
        this._ruleDefRefError = ruleDefRefError;
        this._version = BMUVersion.V104;
    }

    @Override
    public final String getId() {
        return this._id;
    }

    @Override
    public final void setId(String id) {
        this._id = id;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final void setName(String name) {
        this._name = name;
    }

    @Override
    public final RuleDef getRuleDefRefOK() {
        return this._ruleDefRefOK;
    }

    @Override
    public final void setRuleDefRefOK(RuleDef ruleDefRefOK) {
        this._ruleDefRefOK = ruleDefRefOK;
    }

    @Override
    public final RuleDef getRuleDefRefError() {
        return this._ruleDefRefError;
    }

    @Override
    public final void setRuleDefRefError(RuleDef ruleDefRefError) {
        this._ruleDefRefError = ruleDefRefError;
    }

    @Override
    public final List<RuleDef> getRuleList() {
        return this._ruleDefList;
    }

    @Override
    public final void setRuleList(List<RuleDef> ruleDefList) {
        this._ruleDefList = ruleDefList;
        Collections.sort(this._ruleDefList, new RuleDefImpl.RuleDefComparator());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Rulelist sortiert");
            for (RuleDef rule : this._ruleDefList) {
                LOGGER.debug((Object)rule.getName());
            }
        }
    }

    @Override
    public final BMUVersion getVersion() {
        return this._version;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Version=" + String.valueOf((Object)this._version));
        builder.append(", Id=" + this._id);
        builder.append(", Name=" + this._name);
        builder.append(", RuleList=[");
        boolean first = true;
        for (RuleDef ruleDef : this._ruleDefList) {
            if (!first) {
                builder.append(",");
            }
            builder.append("{" + String.valueOf(ruleDef) + "}");
            first = false;
        }
        builder.append("]");
        return builder.toString();
    }

    final void afterUnmarshal(Unmarshaller um, Object parent) {
        LOGGER.debug((Object)"afterUnmarshall called..");
        Collections.sort(this._ruleDefList, new RuleDefImpl.RuleDefComparator());
    }
}

