/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.DocumentController;
import de.consist.bmu.rule.MeldungTyp;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.RuleSet;
import de.consist.bmu.rule.RuleSetResult;
import de.consist.bmu.rule.def.MeldungTypImpl;
import de.consist.bmu.rule.def.RuleDefImpl;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.error.BMUParseException;
import de.consist.bmu.rule.impl.RuleImplSchemaValidation104a;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.impl.RuleSetResultImpl;
import de.consist.bmu.rule.schema.BMUMessageTypeImpl;
import de.consist.bmu.rule.util.ByteUtils;
import de.consist.bmu.rule.util.DateUtils;
import de.consist.bmu.rule.xpath.XPathFassade;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="bmudok", propOrder={"_bmuMessageType"})
@XmlRootElement(name="BMUDokument")
public final class BMUDokumentImpl
implements BMUDokument,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(BMUDokumentImpl.class);
    private static final MeldungTyp MELDUNG_PARSE_ERROR = new MeldungTypImpl(MeldungTyp.FehlerKlasse.KEINXML, MeldungTyp.FehlerStufe.FATAL, "Fehler beim Parsen des Dokuments: ", "PB_X0", "Das Dokument kann nicht verarbeitet werden");
    private static final RuleDef RULEDEF_PARSE_ERROR = new RuleDefImpl("ID_PARSE_ERROR", "ParseError", null, true, new Date(0L), true, MELDUNG_PARSE_ERROR, null, new Date(0L), false);
    private static boolean _validateParse = true;
    @XmlElement(name="MessageType", type=BMUMessageTypeImpl.class)
    private BMUMessageType _bmuMessageType;
    private transient int _size;
    private transient Document _doc;

    public BMUDokumentImpl() {
    }

    private BMUDokumentImpl(Document doc, BMUMessageType bmuMessageType, int size) {
        this._doc = doc;
        this._bmuMessageType = bmuMessageType;
        this._size = size;
    }

    private static void parseError(RuleSet ruleSet, List<RuleResult> ruleResultList, String msg, RuleSetResult.Status status) throws BMUParseException {
        String bezugMessage = "Pr\u00fcfzeitpunkt: " + DateUtils.toDateTimeString(new Date());
        RuleResultImpl bezugResult = new RuleResultImpl(ruleSet.getRuleDefBezugError(), 1, bezugMessage);
        RuleSetResultImpl ruleSetResult = new RuleSetResultImpl(null, null, ruleResultList, bezugResult, MeldungTyp.FehlerStufe.FATAL, status);
        throw new BMUParseException(msg, (RuleSetResult)ruleSetResult);
    }

    public static BMUDokument parse(InputStream is, RuleSet ruleSet) throws BMUParseException {
        BMUDokument bmuDok = null;
        ArrayList<RuleResult> ruleResultList = null;
        try {
            byte[] data = ByteUtils.readFromStream(is);
            bmuDok = BMUDokumentImpl.parse(new ByteArrayInputStream(data), data.length, ruleSet);
        }
        catch (BMUException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("parse error: " + e.getMessage()));
            }
            RuleResultImpl ruleResult = new RuleResultImpl(RULEDEF_PARSE_ERROR, 1, e.getMessage());
            ruleResultList = new ArrayList<RuleResult>();
            ruleResultList.add(ruleResult);
            BMUDokumentImpl.parseError(ruleSet, ruleResultList, e.getMessage(), RuleSetResult.Status.PARSE_ERROR);
        }
        return bmuDok;
    }

    public static BMUDokument parse(InputStream is, int size, RuleSet ruleSet) throws BMUParseException {
        Document doc = null;
        BMUMessageTypeImpl msgType = null;
        List<RuleResult> ruleResultList = null;
        try {
            RuleImplSchemaValidation104a ruleSchemaValidation;
            doc = DocumentController.parse(is);
            boolean isOSCIQuittung = false;
            try {
                isOSCIQuittung = XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "local-name(.)='Envelope'");
            }
            catch (XPathExpressionException e) {
                LOGGER.warn((Object)("error evaluating XPath 'local-name(.)='Envelope'': " + e.getMessage()));
            }
            if (!isOSCIQuittung && _validateParse && (ruleResultList = (ruleSchemaValidation = (RuleImplSchemaValidation104a)ruleSet.getRuleById("ID_042")).executeInternal(doc)).size() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"schema error");
                }
                BMUDokumentImpl.parseError(ruleSet, ruleResultList, "Schema validation failed", RuleSetResult.Status.SCHEMA_ERROR);
            }
            msgType = BMUMessageTypeImpl.getMessageType(doc);
        }
        catch (BMUException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("parse error: " + e.getMessage()));
            }
            RuleResultImpl ruleResult = new RuleResultImpl(RULEDEF_PARSE_ERROR, 1, e.getMessage());
            ruleResultList = new ArrayList<RuleResult>();
            ruleResultList.add(ruleResult);
            BMUDokumentImpl.parseError(ruleSet, ruleResultList, e.getMessage(), RuleSetResult.Status.PARSE_ERROR);
        }
        return new BMUDokumentImpl(doc, msgType, size);
    }

    public static BMUDokument parse(File file, RuleSet ruleSet) throws BMUParseException {
        BMUDokument bmuDok = null;
        ArrayList<RuleResult> ruleResultList = null;
        try {
            bmuDok = BMUDokumentImpl.parse(new FileInputStream(file), (int)file.length(), ruleSet);
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("file not found: " + file.getAbsolutePath()));
            }
            RuleResultImpl ruleResult = new RuleResultImpl(RULEDEF_PARSE_ERROR, 1, e.getMessage());
            ruleResultList = new ArrayList<RuleResult>();
            ruleResultList.add(ruleResult);
            BMUDokumentImpl.parseError(ruleSet, ruleResultList, e.getMessage(), RuleSetResult.Status.PARSE_ERROR);
        }
        return bmuDok;
    }

    @Override
    public Document getDocument() {
        return this._doc;
    }

    @Override
    public BMUMessageType getMessageType() {
        return this._bmuMessageType;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        LOGGER.trace((Object)"<BMUDokumentImpl.writeObject>");
        oos.defaultWriteObject();
        this.writeDocument(oos, this._doc);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        LOGGER.trace((Object)"<BMUDokumentImpl.readObject>");
        ois.defaultReadObject();
        this._doc = this.readDocument(ois);
    }

    private void writeDocument(ObjectOutputStream oos, Document doc) throws IOException {
        if (doc == null) {
            oos.writeInt(0);
        } else {
            byte[] b1 = null;
            try {
                b1 = DocumentController.serialize(doc);
            }
            catch (BMUException e) {
                LOGGER.error((Object)"<BMUDokumentImpl.writeDocument> Fehler", (Throwable)e);
                throw new IOException(e.getMessage());
            }
            oos.writeInt(b1.length);
            if (b1.length > 0) {
                oos.write(b1);
            } else {
                LOGGER.error((Object)("Unerwarteter Zustand: L\u00e4nge des Bytearray kleiner 1 (" + Integer.toString(b1.length) + ")"));
            }
        }
    }

    private Document readDocument(ObjectInputStream ois) throws IOException {
        int len = ois.readInt();
        if (len > 0) {
            byte[] buf = new byte[len];
            ois.readFully(buf);
            this._size = buf.length;
            try {
                return DocumentController.parse(buf);
            }
            catch (BMUException e) {
                LOGGER.error((Object)"<BMUDokumentImpl.readDocument> Fehler", (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
        return null;
    }

    public static boolean isValidateParse() {
        return _validateParse;
    }

    public static void setValidateParse(boolean validateParse) {
        _validateParse = validateParse;
    }

    public static class Adapter
    extends XmlAdapter<BMUDokumentImpl, BMUDokument> {
        public final BMUDokument unmarshal(BMUDokumentImpl bmuDokImpl) {
            return bmuDokImpl;
        }

        public final BMUDokumentImpl marshal(BMUDokument bmuDok) {
            return (BMUDokumentImpl)bmuDok;
        }
    }
}

