/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public final class RuleImplFixedText
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplFixedText.class);
    private static final String[] XPATH_ENS_FIXED_TEXT = new String[]{"en:VerantwortlicheErklaerung/en:Versicherung", "en:Erklaerung/en:Versicherung", "en:HinweisGebuehr", "en:HinweisRechtsbehelf"};
    private static final String[] XPATH_FR_FIXED_TEXT = new String[]{"en:Antrag/en:Text", "en:HinweisGebuehr", "en:HinweisRechtsbehelf"};
    private static final String[] XPATH_BGS_FIXED_TEXT = new String[]{"bgs:Erzeuger/bgs:Versicherung", "bgs:Befoerderer/bgs:VersicherungErsterBef", "bgs:Befoerderer/bgs:VersicherungWeitererBef", "bgs:Lager/bgs:Versicherung", "bgs:Entsorger/bgs:Versicherung"};
    private static final String[] XPATH_EGF_FIXED_TEXT = new String[]{"en:Nummer1_Antrag/en:Text", "en:Nummer1_Antrag/en:TextVollmacht", "en:Nummer2_Bevollmaechtigung/en:Text", "en:Nummer3_Beauftragung/en:Text"};
    private static final String[] XPATH_RGA_FIXED_TEXT = new String[]{"zks:Registrierungsantrag/zks:Versicherung", "zks:RegistrierungsantragZKS/zks:Versicherung"};

    public RuleImplFixedText(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> evalFixedText(Document doc, String[] xPathes) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        for (String xpFT : xPathes) {
            try {
                if (!XPathFassade.getInstance().evalBool(doc.getDocumentElement(), "/descendant::" + xpFT + "=''")) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, xpFT));
            }
            catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Pr\u00fcfen", e);
            }
        }
        return ruleResultList;
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok.getMessageType();
        switch (msgType.getEnumType()) {
            case ENSNDokument: {
                ruleResultList.addAll(this.evalFixedText(doc, XPATH_ENS_FIXED_TEXT));
                break;
            }
            case BGSDokument: {
                ruleResultList.addAll(this.evalFixedText(doc, XPATH_BGS_FIXED_TEXT));
                break;
            }
            case FRDokument: {
                ruleResultList.addAll(this.evalFixedText(doc, XPATH_FR_FIXED_TEXT));
                break;
            }
            case EGFDokument: {
                ruleResultList.addAll(this.evalFixedText(doc, XPATH_EGF_FIXED_TEXT));
                break;
            }
            case RegisterAnforderung: {
                ruleResultList.addAll(this.evalFixedText(doc, XPATH_RGA_FIXED_TEXT));
                break;
            }
            default: {
                LOGGER.warn((Object)("unexpected message-type: " + String.valueOf((Object)msgType.getEnumType())));
            }
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("F\u00fcr die Pr\u00fcfung werden folgende XPath-Ausdr\u00fccke verwendet:");
        builder.append("\n");
        builder.append("ENSNDokument: " + Arrays.deepToString(XPATH_ENS_FIXED_TEXT));
        builder.append("\n");
        builder.append("BGSDokument: " + Arrays.deepToString(XPATH_BGS_FIXED_TEXT));
        builder.append("\n");
        builder.append("FRDokument: " + Arrays.deepToString(XPATH_FR_FIXED_TEXT));
        builder.append("\n");
        builder.append("EGFDokument: " + Arrays.deepToString(XPATH_EGF_FIXED_TEXT));
        builder.append("\n");
        builder.append("Registeranforderung: " + Arrays.deepToString(XPATH_RGA_FIXED_TEXT));
        return builder.toString();
    }
}

