/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.NodeList;

public final class RuleImplLayerIDSequence
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final int LAYERID_SEQUENCE_ENDPOS = 6;
    private static final int LAYERID_SEQUENCE_STARTPOS = 4;
    private static final String XPATH_LAYER = "/descendant::*/@lib:LayerID";

    public RuleImplLayerIDSequence(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        NodeList nl;
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), XPATH_LAYER);
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        int layerIdIndex = 1;
        int index = 1;
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            String layerId = nl.item(i).getTextContent();
            String layerIdSequencePart = layerId.substring(4, 6);
            int layerIdSequence = Integer.parseInt(layerIdSequencePart);
            if (layerIdSequence != layerIdIndex) {
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, layerId));
            }
            ++layerIdIndex;
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return "XPath f\u00fcr die Ermittlung der LayerID: /descendant::*/@lib:LayerID";
    }
}

