/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RuleImplSignatureEIDAS
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureEIDAS.class);
    private static final String TECHDOC = "Pr\u00fcft die Signaturen im Dokument auf die Verwendung von Elementen nach der eIDAS Verordnung";

    public RuleImplSignatureEIDAS(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        List<SignatureVerificationResult> svrList = bmuDok.getMessageType().getSignatureVerificationResultList();
        int index = 1;
        for (SignatureVerificationResult svr : svrList) {
            if (!svr.isEnabled(this.getRuleDef()) || !svr.isEIDAS()) continue;
            String msg = "Signatur mit Elementen nach der eIDAS Verordnung, ID: " + svr.getSignatureID();
            LOGGER.debug((Object)msg);
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, svr.getSignatureID()));
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return TECHDOC;
    }
}

