/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureXadesURI
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureXadesURI.class);
    private static final String XPATH_XERCES_URI = "count(ds:SignedInfo/ds:Reference[string-length(@URI)>0])=0";
    private static final String TECHDOC = "Pr\u00fcft die Xades-Referenz (ds:Signature/ds:SignedInfo/ds:Reference) in allen Signaturen im Dokument auf die Verwendung eines URI-Attributes.";

    public RuleImplSignatureXadesURI(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            NodeList nodeList = xpf.evaluateNodeList(bmuDok.getDocument(), "/descendant::ds:Signature[@Id]");
            int index = 1;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node sigNode = nodeList.item(i);
                String sigId = sigNode.getAttributes().getNamedItem("Id").getTextContent();
                SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigId);
                if (svr == null || !svr.isEnabled(this.getRuleDef()) || !xpf.evalBool((Element)sigNode, XPATH_XERCES_URI)) continue;
                String msg = "Keine Xades-Reference in der Signatur mit der ID: " + sigId;
                LOGGER.debug((Object)msg);
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigId));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        return TECHDOC;
    }
}

