/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.impl;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.impl.RuleImpl;
import de.consist.bmu.rule.impl.RuleResultImpl;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class RuleImplSignatureXmlDSig11
extends RuleImpl {
    private static final long serialVersionUID = 1L;
    private static final String XPATH_ECKEYVALUE = "/descendant::" + Namespace.xmldsig11.getPrefix() + ":ECKeyValue";

    public RuleImplSignatureXmlDSig11(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        ArrayList<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        try {
            NodeList nl = xpf.evaluateNodeList(bmuDok.getDocument(), XPATH_ECKEYVALUE);
            int index = 1;
            for (int i = 0; i < nl.getLength(); ++i) {
                Element keyNode = (Element)nl.item(i);
                String sigID = XPathFassade.getInstance().evaluate(keyNode, "ancestor::ds:Signature/@Id");
                SignatureVerificationResult svr = bmuDok.getMessageType().getSignatureVerificationResult(sigID);
                if (!svr.isEnabled(this.getRuleDef()) || svr.isEIDAS()) continue;
                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, sigID));
            }
        }
        catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Pr\u00fcfen", e);
        }
        return ruleResultList;
    }

    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath f\u00fcr die Ermittlung der zu pr\u00fcfenden Inhalte: ");
        builder.append(XPATH_ECKEYVALUE);
        return builder.toString();
    }
}

