/*
 * Decompiled with CFR 0.152.
 */
package de.consist.bmu.rule.xpath;

import de.consist.bmu.rule.schema.Namespace;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathFassade {
    private static XPathFassade _theInstance = new XPathFassade();
    private static final Log LOGGER = LogFactory.getLog(XPathFassade.class);
    private XPathFactory _xf = XPathFactory.newInstance();
    private NamespaceContext _ctx = Namespace.getNamespaceContext();

    private XPathFassade() {
    }

    public static synchronized XPathFassade getInstance() {
        return _theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evaluate(String expression, Element item, QName returnType) throws XPathExpressionException {
        Document ownerDoc;
        XPath xp = this._xf.newXPath();
        xp.setNamespaceContext(this._ctx);
        Object result = null;
        Document document = ownerDoc = item.getOwnerDocument();
        synchronized (document) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<evaluate> expression: '" + expression + "', context: '" + item.getNodeName() + "', returnType: '" + String.valueOf(returnType) + "'"));
            }
            result = xp.evaluate(expression, item, returnType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("<evaluate> result: " + String.valueOf(result)));
            }
        }
        return result;
    }

    public NodeList evaluateNodeList(Element root, String expression) throws XPathExpressionException {
        return (NodeList)this.evaluate(expression, root, XPathConstants.NODESET);
    }

    public NodeList evaluateNodeList(Document doc, String expression) throws XPathExpressionException {
        return this.evaluateNodeList(doc.getDocumentElement(), expression);
    }

    public Node evaluateNode(Document doc, String expression) throws XPathExpressionException {
        return this.evaluateNode(doc.getDocumentElement(), expression);
    }

    public Node evaluateNode(Element root, String expression) throws XPathExpressionException {
        return (Node)this.evaluate(expression, root, XPathConstants.NODE);
    }

    public String evaluate(Document doc, String expression) throws XPathExpressionException {
        return this.evaluate(doc.getDocumentElement(), expression);
    }

    public String evaluate(Element root, String expression) throws XPathExpressionException {
        return (String)this.evaluate(expression, root, XPathConstants.STRING);
    }

    public boolean evalBool(Element elem, String expression) throws XPathExpressionException {
        return (Boolean)this.evaluate(expression, elem, XPathConstants.BOOLEAN);
    }

    public double evalNumber(Element elem, String expression) throws XPathExpressionException {
        return (Double)this.evaluate(expression, elem, XPathConstants.NUMBER);
    }
}

