/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 */
package de.consist.bmu.rule;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.w3c.dom.Document;

import de.consist.bmu.rule.impl.BMUDokumentImpl;

/**
 * Interface f&uuml;r ein BMU-Dokument.
 * 
 * Der Erstellungszeitpunkt des Dokuments kann ber den BMUMessageType abgefragt
 * werden.
 * 
 * @see BMUMessageType#getFirstSignTime()
 */
@XmlJavaTypeAdapter(BMUDokumentImpl.Adapter.class)
public interface BMUDokument {

    /**
     * Gibt das Dokument zur&uuml;ck.
     * 
     * @return Document
     */
    Document getDocument();

    /**
     * Gibt zus&auml;tzliche Informationen zu dem Dokument zur&uuml;ck.
     * 
     * @return BMUMessageType
     */
    BMUMessageType getMessageType();
    
    /**
     * Gibt die Groesse des Dokuments in Bytes zurueck.
     * 
     * @return int
     */
    int getSize();
}
