package de.consist.bmu.rule;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import de.consist.bmu.rule.schema.Namespace;

/**
 * Enumeration der BMU-Dokumenttypen.
 */
public enum BMUMessageTypeEnum {
	/** ENSNDokument. */
	ENSNDokument(
			Namespace.EN,
			new String[] { "/descendant::lib:NachweisNr[not(ancestor::en:EGFDokument) and not(ancestor::ags:AGSBescheid) and not(ancestor::en:DADokument)]",
					"/descendant::en:VorlaeufigeENNr[not(ancestor::en:DADokument)]" },
			"ENS",
			true),
	/** FRDokument. */
	FRDokument(
			Namespace.EN,
			new String[] { "/descendant::lib:FreistellungsNr[1]", "/descendant::en:VorlaeufigeFRNr[1]" },
			"FR",
			true),
	/** BGSDokument. */
	BGSDokument(
			Namespace.Begleitschein,
			new String[] { "/descendant::lib:PaginierNr[parent::bgs:BGSNummer][1]" },
			"BGS",
			true),
	/** UNSDokument. */
	UNSDokument(
			Namespace.Begleitschein,
			new String[] { "/descendant::lib:PaginierNr[parent::bgs:UNSNummer][1]" },
			"UNS",
			true),
	/** RegisterAnforderung. */
	RegisterAnforderung(
			Namespace.Register,
			new String[] { "/descendant::lib:RegisterNr" },
			"RA",
			false),
	/** RegisterAuszug. */
	RegisterAuszug(
			Namespace.Register,
			new String[] { "concat(/descendant::lib:RegisterNr,'_',/descendant::reg:LfdNrTeilauszug)" },
			"RG",
			true),
	/** Abfallverbringungsdokument. */
	Abfallverbringungsdokument(
			Namespace.Notifizierung,
			new String[] { "/descendant::userram:NotificationIdentificationID",
					"concat(/descendant::userram:CorrespondingNotificationIdentificationID,'_',/descendant::userram:ConsecutiveTransportNumberNumeric)" },
			"AVD",
			false),
	/** Quittung. */
	Quittung(
			Namespace.Nachricht,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"QT",
			false),
	/** Mitteilung. */
	Mitteilung(
			Namespace.Nachricht,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"MT",
			false),
	/** Registrierungsantrag. */
	Registrierungsantrag(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AntragUUID" },
			"RAN",
			false),
	/** Registrierungsantrag intern. */
	RegistrierungsantragZKS(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AntragUUID" },
			"RAN",
			false),
	/** Registrierungsauftrag. */
	Registrierungsauftrag(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AntragUUID" },
			"RAU",
			false),
	/** Registrierungsauftrag intern. */
	RegistrierungsauftragZKS(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AntragUUID" },
			"RAU",
			false),
	/** ZKSAuftrag. */
	ZKSAuftrag(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AuftragUUID" },
			"ZKA",
			false),
	/** ZKSErgebnis. */
	ZKSErgebnis(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AuftragUUID" },
			"ZKE",
			false),
	/** ZKSParameterAnfrage. */
	ZKSParameterAnfrage(
			Namespace.ZKS,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"PAN",
			false),
	/** ZKSParameterErgebnis. */
	ZKSParameterErgebnis(
			Namespace.ZKS,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"PAT",
			false),
	/** EGFDokument. */
	EGFDokument(
			Namespace.EN,
			new String[] { "/descendant::lib:NachweisNr" },
			"EGF",
			false),
	/** AGSBescheid. */
	AGSBescheid(
			Namespace.AGS,
			new String[] { "/descendant::lib:NachweisNr" },
			"EGB",
			false),
	/** DADokument. */
	DADokument(
			Namespace.DA,
			new String[] { "/descendant::lib:NachweisNr" },
			"DAD",
			false),
	/** Adressanfrage. */
	Adressanfrage(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AnfrageUUID" },
			"ASA",
			false),
	/** Adressantwort. */
	Adressantwort(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AnfrageUUID" },
			"ASL",
			false),
	/** Adressanforderung. */
	Adressanforderung(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AnforderungUUID" },
			"AST",
			false),
	/** Adressauskunft. */
	Adressauskunft(
			Namespace.ZKS,
			new String[] { "/descendant::zks:AnforderungUUID" },
			"ASZ",
			false),
	/** Nachweisliste. */
	Nachweisliste(
			Namespace.ZKS,
			new String[] { "/descendant::lib:PaginierNr" },
			"NWL",
			false),
	/** Zertifikatsuebermittlung. */
	Zertifikatsuebermittlung(
			Namespace.ZKS,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"RZT",
			false),
	/** BGSNrAnforderung. */
	BGSNrAnforderung(
			Namespace.ZKS,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"NRA",
			false),
	/** BGSNrZuteilung. */
	BGSNrZuteilung(
			Namespace.ZKS,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"NRZ",
			false),
	/** Registrierungsquittung. */
	Registrierungsquittung(
			Namespace.ZKS,
			new String[] { "/msg:Nachricht/@msg:MsgUUID" },
			"RQT",
			false),
	/** ENSNVorlageLayerRE. */
	ENSNVorlageLayerRE(
			Namespace.EN,
			new String[] { "/descendant::lib:NachweisNr", "/descendant::en:VorlaeufigeENNr" },
			"Intern",
			false),
    /** DiWaSSRegAntrag. */
	DiWaSSRegAntrag(
            Namespace.ZKS,
            new String[] { "/descendant::wsr:RequestUUID" },
            "DRQ",
            false),
    /** DiWaSSRegAntwort. */
    DiWaSSRegAntwort(
            Namespace.ZKS,
            new String[] { "/descendant::wsr:ReplyUUID" },
            "DRS",
            false),
//	/** AbfAEV-Anzeige. */
//	Anzeige(
//			Namespace.abfaev,
//			new String[] { "/descendant::abfaev:Vorgangsnummer[parent::abfaev:Vorgangsnummer]", "/msg:Nachricht/@msg:MsgUUID" },
//			"ANZ",
//			false),
//	/** AbfAEV-AnzeigeUnterlagen. */
//	AnzeigeUnterlagen(
//			Namespace.abfaev,
//			new String[] { "/descendant::abfaev:Vorgangsnummer[parent::abfaev:Vorgangsnummer]", "/msg:Nachricht/@msg:MsgUUID" },
//			"ANZ",
//			false),
//	/** AbfAEV-ErlaubnisAntrag. */
//	ErlaubnisAntrag(
//			Namespace.abfaev,
//			new String[] { "/descendant::abfaev:Vorgangsnummer[parent::abfaev:Vorgangsnummer]", "/msg:Nachricht/@msg:MsgUUID" },
//			"ERL",
//			false),
//	/** AbfAEV-ErlaubnisUnterlagen. */
//	ErlaubnisUnterlagen(
//			Namespace.abfaev,
//			new String[] { "/descendant::abfaev:Vorgangsnummer[parent::abfaev:Vorgangsnummer]", "/msg:Nachricht/@msg:MsgUUID" },
//			"ERL",
//			false),
//	/** AbfAEV-AsysRueckantwort. */
//	AsysRueckantwort(
//			Namespace.abfaev,
//			new String[] { "/descendant::abfaev:Vorgangsnummer[parent::abfaev:Vorgangsnummer]", "/msg:Nachricht/@msg:MsgUUID" },
//			"ARA",
//			false),
//	/** Erzeuger-Stammdaten. */
//	Erzeuger(
//			Namespace.erzst,
//			new String[] { "/descendant::erzst:Aktenzeichen", "/msg:Nachricht/@msg:MsgUUID" },
//			"ERZ",
//			false),
	/** Envelope. */
	Envelope(
			Namespace.osci,
			new String[] { "//osci:ControlBlock" },
			"OSCI",
			false);
	private final Namespace _ns;
	private final String[] _xPathNummer;
	private final String _bmuType;
	private final boolean _layerDoc;
	private static final Map<String, BMUMessageTypeEnum> LOOKUPMAP = new HashMap<String, BMUMessageTypeEnum>();

	static {
		for (BMUMessageTypeEnum s : EnumSet.allOf(BMUMessageTypeEnum.class)) {
			BMUMessageTypeEnum.LOOKUPMAP.put(s._bmuType, s);
		}
	}

	private BMUMessageTypeEnum(Namespace ns, String[] xPathNummer, String bmuType, boolean layerDoc) {
		_ns = ns;
		_xPathNummer = xPathNummer;
		_bmuType = bmuType;
		_layerDoc = layerDoc;
	}

	/**
	 * @return Der target-ns des Dokuments
	 */
	public Namespace getNS() {
		return _ns;
	}

	/**
	 * @return Der XPath zum Ermitteln der fachlichen Nummer
	 */
	public String[] getXPathNummer() {
		return _xPathNummer;
	}

	/**
	 * @return Der BMU-Typ
	 */
	public String getBMUType() {
		return _bmuType;
	}

	/**
	 * @return true, wenn es sich um ein Layer-Dokument handelt
	 */
	public boolean isLayerDoc() {
		return _layerDoc;
	}

	/**
	 * @param msgType
	 *            String
	 * @return BMUMessaageType
	 */
	public static BMUMessageTypeEnum lookup(String msgType) {
		return BMUMessageTypeEnum.LOOKUPMAP.get(msgType);
	}
}
