/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule;

import java.io.Serializable;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import de.consist.bmu.rule.def.MeldungTypImpl;


/**
 * Interface fuer die Meldung in der Quittung und in der Regeldefinition.
 */
@XmlJavaTypeAdapter(MeldungTypImpl.Adapter.class)
public interface MeldungTyp extends Serializable {

    /**
     * Enumeration der Fehlerklassen.
     */
    public enum FehlerKlasse {
        /** Kein Fehler. */
        KEINFEHLER,
        /** Kein Xml-Dokument. */
        KEINXML,
        /** Dokument ist nicht Schemavalide. */
        KEINSCHEMA,
        /** Fehler in den Signaturen des Dokuments. */
        SIGNATURFEHLER,
        /** Fehlernder Inhalt. */
        INHALTFEHLT,
        /** Falscher Inhalt. */
        INHALTFALSCH,
        /** Fehler in den Anhaengen. */
        ANHANG,
        /** Sonstiges. */
        SONSTIGES;
    }

    /**
     * Enumeration der Fehlerstufen.
     */
    public enum FehlerStufe {
        /** Fatal. */
        FATAL(4),
        /** Fehler. */
        FEHLER(3),
        /** Warnung. */
        WARNUNG(2),
        /** Info. */
        INFO(1),
    	/** Debug. */
    	DEBUG(0);
        
        private int _stufe;
        FehlerStufe(int stufe) {
            _stufe = stufe;
        }
        
        /**
         * @return Die Fehlerstufe
         */
        public int getStufe() {
            return _stufe;
        }
        
        public static FehlerStufe getFehlerStufe(int i) {
        	if (i == 0) {
        		return DEBUG;
        	} else if (i == 1) {
        		return INFO;
        	} else if (i == 2) {
        		return WARNUNG;
        	} else if (i == 3) {
        		return FEHLER;
        	} else if (i == 4) {
        		return FATAL;
        	}
        	return null;
        }
    }

    /**
     * @return Die Fehlerklasse
     */
    FehlerKlasse getKlasse();

    /**
     * @param klasse
     *            Die Fehlerklasse
     */
    void setKlasse(FehlerKlasse klasse);

    /**
     * @return Die Fehlerstufe
     */
    FehlerStufe getStufe();

    /**
     * @param stufe
     *            Die Fehlerstufe
     */
    void setStufe(FehlerStufe stufe);

    /**
     * @return Die Beschreibung
     */
    String getBeschreibung();

    /**
     * @param beschreibung
     *            Die Beschreibung
     */
    void setBeschreibung(String beschreibung);

    /**
     * @return Der Code
     */
    String getCode();

    /**
     * @param code
     *            Der Code
     */
    void setCode(String code);

    /**
     * @return Der Abhilfetext
     */
    String getAbhilfe();

    /**
     * @param abhilfe
     *            Der Abhilfetext
     */
    void setAbhilfe(String abhilfe);

//    /**
//     * @return Die Version
//     */
//    BMUVersion getVersion();

}
