/**
 * BMUPruefBibliothek
 * $Author: jannighoefer $ $Date: 2012-03-09 15:09:11 +0000 (Fri, 09 Mar 2012) $ $Rev: 824 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule;

import java.io.Serializable;
import java.util.List;

/**
 * Interface fuer eine Liste von Regeldefinitionen.
 * 
 * Diese muss zur Ausfhrung in ein RuleSet berfhrt werden.
 * 
 * TODO Knnte hier nicht ein Stichtag Sinn machen, der fr alle Prfungen gilt?
 * 
 * @see RuleSet
 */
public interface RuleSetDef extends Serializable {

    /**
     * @return the _id
     */
    String getId();

    /**
     * @param id
     *            the _id to set
     */
    void setId(String id);

    /**
     * @return the _name
     */
    String getName();

    /**
     * @param name
     *            the _name to set
     */
    void setName(String name);

    /**
     * @return the _ruleDefRefOK
     */
    RuleDef getRuleDefRefOK();

    /**
     * @param ruleDefRefOK
     *            the ruleDefRefOK to set
     */
    void setRuleDefRefOK(RuleDef ruleDefRefOK);

    /**
     * @return the _ruleDefRefError
     */
    RuleDef getRuleDefRefError();

    /**
     * @param ruleDefRefError
     *            the ruleDefRefError to set
     */
    void setRuleDefRefError(RuleDef ruleDefRefError);

    /**
     * 
     * @return the _ruleList
     */
    List<RuleDef> getRuleList();

    /**
     * @param ruleDefList
     *            the _ruleList to set
     */
    void setRuleList(List<RuleDef> ruleDefList);

    /**
     * @return Die Version
     */
    BMUVersion getVersion();

}
