/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2014-11-24 17:25:22 +0100 (Mo, 24 Nov 2014) $ $Rev: 1355 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.config.schema.fxs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

import de.consist.bmu.rule.RuleFactory;
import de.consist.bmu.rule.schema.LSInputImpl;

/**
 * LSResourceResolver Implementation f&uuml;r die Benutzung von
 * {@link FXSSchemaValidator}. Benutzte Resourcen werden in einer internen Map
 * gehalten.
 * 
 * @author srossbroich
 */
public class FXSSchemaResourceResolver implements LSResourceResolver {

    private static final Log LOGGER = LogFactory
            .getLog(FXSSchemaResourceResolver.class);

    private List<FXSSCHEMATYPE> _fxsSchemaList; 
    
    /**
     * Default Konstruktor.
     * 
     * @param fxsSchemaList
     *            Liste der Schemas
     */
    public FXSSchemaResourceResolver(final List<FXSSCHEMATYPE> fxsSchemaList) {
    	_fxsSchemaList = fxsSchemaList;
    }

    /**
     * Ruft resolveResource(String type, String namespaceURI, String publicId,
     * String systemId, String baseURI)) mit type und namespaceURI sind null
     * gesetzt.
     * 
     * @param publicId
     *            PUBLIC id
     * @param systemId
     *            SYSTEM id
     * @param baseURI
     *            baseURI
     * @return ressource
     * 
     */
    public final LSInput resolveResource(final String publicId,
            final String systemId, final String baseURI) {
        return resolveResource(null, null, publicId, systemId, baseURI);
    }

    /**
     * Sucht die angegebene Resource anhand der lokal verf&uuml;gbaren Resourcen.
     * 
     * @param type
     *            - The type of the resource being resolved. For XML [XML 1.0]
     *            resources (i.e. entities), applications must use the value
     *            "http://www.w3.org/TR/REC-xml". For XML Schema [XML Schema
     *            Part 1] , applications must use the value
     *            "http://www.w3.org/2001/XMLSchema".
     * @param namespaceURI
     *            - The namespace of the resource being resolved, e.g. the
     *            target namespace of the XML Schema [XML Schema Part 1] when
     *            resolving XML Schema resources.
     * @param publicId
     *            - The public identifier of the external entity being
     *            referenced, or null if no public identifier was supplied or if
     *            the resource is not an entity.
     * @param systemId
     *            - The system identifier, a URI reference [IETF RFC 2396], of
     *            the external resource being referenced, or null if no system
     *            identifier was supplied.
     * @param baseURI
     *            - The absolute base URI of the resource being parsed, or null
     *            if there is no base URI.
     * @return A ByteStream connected to the resource
     * 
     * 
     */
    public final LSInput resolveResource(final String type,
            final String namespaceURI, final String publicId,
            final String systemId, final String baseURI) {
        LOGGER.debug("trying to resolve: type=" + type + ", publicId=" + publicId + ", systemId=" + systemId + ", baseURI=" + baseURI + ", namespaceUR=" + namespaceURI);
    	LSInput lsInput = new LSInputImpl();
        URL url = null;
        try {
        	if (systemId != null) {
        		if ("http://www.w3.org/2001/XMLSchema.dtd".equals(systemId)) {
        			url = getClass().getResource("/de/consist/bmu/schema-1.04a/2001/XMLSchema.dtd");
        		} else {
		        	try {
		        		url = new URL(systemId);
//                        url = new URI(systemId).toURL();
		        	} catch (MalformedURLException ex) {
		        	}
        		}
        	}
        	if (url == null) {
	        	for (FXSSCHEMATYPE fxsschematype : _fxsSchemaList) {
		        	String nsURI = fxsschematype.getNSUri();
		        	if (nsURI.equals(systemId) || nsURI.equals(publicId) || nsURI.equals(namespaceURI)) {
						File schemaFile = new File(fxsschematype.getLocation());
						if (!schemaFile.exists() && !schemaFile.isAbsolute()) {
							schemaFile = new File(RuleFactory.getInstance().getFxsSchemaBaseDir(), fxsschematype.getLocation());
						}
		        		if (schemaFile.exists()) {
		        			url = schemaFile.toURI().toURL();
		        		}
						break;
					}
				}
        	}
	        if (url == null && systemId != null) {
				url = new File(RuleFactory.getInstance().getFxsSchemaBaseDir(), systemId).toURI().toURL();
			}
	        if (url == null) {
	            LOGGER.error("unable to resolve: systemId=" + systemId
	                    + ", pubicId=" + publicId + ", namespaceURI="
	                    + namespaceURI);
	        } else {
	        	LOGGER.debug("resolved: " + url.toExternalForm());
                lsInput.setByteStream(url.openStream());
	        }
        } catch (Exception e) {
            LOGGER.error("Error resolving resource: " + ((url != null) ? url.getPath() : "null"), e);
        }
        return lsInput;
    }

}
