/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-01-19 01:50:18 +0100 (Sa, 19 Jan 2013) $ $Rev: 978 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplAttachmentSize extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory.getLog(RuleImplAttachmentSize.class);
    
    /**
     * XPath fuer lib:Pruefsumme.
     */
    private static final String XPATH_DATEIANHANG = "/descendant::*[local-name()='Dateianhang' and @lib:id]";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplAttachmentSize(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(),
                    XPATH_DATEIANHANG);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); i++) {
            Node nodeDateianhang = nl.item(i);
            if (nodeDateianhang instanceof Element) {
                Element elemDateianhang = (Element) nodeDateianhang;
                String id = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
                if (elemDateianhang.hasAttributeNS(Namespace.TypenBibliothek.getUri(), "dateigroesse")) {
                    String attrLengthString = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "dateigroesse");
                    int attrLength = Integer.parseInt(attrLengthString);
                    try {
                        NodeList nodeListBinaerdaten = elemDateianhang.getElementsByTagNameNS(Namespace.TypenBibliothek.getUri(), "Binaerdaten");
                        if (nodeListBinaerdaten.getLength() > 0) {
                            String binaerDaten = nodeListBinaerdaten.item(0).getTextContent();
                            byte[] decodedBinaerdaten = Base64.decodeBase64(binaerDaten);
                            int actualLength = decodedBinaerdaten.length;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("attribute length: " + attrLength);
                                LOGGER.debug("actual length: " + actualLength);
                            }
                            if (attrLength != actualLength) {
                                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
                            }
                        }
                    } catch (Exception e) {
                        LOGGER.error("Error decoding content of element 'Binaerdaten'", e);
                        ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
                    }
                }
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath fr die Ermittlung der Dateianhnge: " + XPATH_DATEIANHANG;
    }

}
