/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 10:24:11 +0200 (Fr, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.TypeLister;
import de.consist.bmu.rule.util.XmlElementInfo;
import de.consist.bmu.rule.util.XmlUtils;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author candersen
 * 
 */
public final class RuleImplDateInInterval extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplDateInInterval(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        Document document = bmuDok.getDocument();
        Set<XmlElementInfo> dateList = TypeLister.getDateTypes(document);
        for (XmlElementInfo info : dateList) {
            int index = 1;
            try {
                String xpath = "/descendant::*[local-name()='"+ info.get_localName() +"' and namespace-uri()='"+ info.get_uri() +"']";
                nl = XPathFassade.getInstance().evaluateNodeList(document, xpath);
                for (int i = 0; i < nl.getLength(); i++) {
                    Node node = nl.item(i);
                    String dateString = node.getTextContent();
                    Date date;
                    try {
                        if (dateString.contains("T")) {
                            dateString = dateString.replace("T", " ");
                            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
                                    .parse(dateString);
                        } else {
                            date = new SimpleDateFormat("yyyy-MM-dd")
                                    .parse(dateString);
                        }
                        String path = XmlUtils.getNodePathShort(node);
                        
                        if (!dateInInterval(date)) {
                            ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, path));
                        }
                    } catch (ParseException e) {
                        throw new BMUException("Fehler beim Prfen", e);
                    }
                }
            } catch (XPathExpressionException e1) {
                throw new BMUException("Fehler beim Prfen", e1);
            }
        }
        return ruleResultList;
    }

    private boolean dateInInterval(Date date) {
        boolean inInterval = true;
        GregorianCalendar gc_before = new GregorianCalendar(1753, 1, 1);
        Date notBefore = gc_before.getTime();
        GregorianCalendar gc_after = new GregorianCalendar(4711, 12, 31);
        Date notAfter = gc_after.getTime();
        if (date.after(notAfter) || date.before(notBefore)) {
            inInterval = false;
        }
        return inInterval;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "Zu prfende Typen: xs:Date, xs:DateTime, lib:DatumTyp";
    }

}
