/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;


import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplEGFAktennummer extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer bgs:Menge.
     */
    private static final String XPATH_AKTENNUMMER = "(count(/descendant::lib:NachweisNr)=0 "
            + "or contains(/descendant::lib:NachweisNr, 'XXXXXXXXX')) "
            + "and string-length(/descendant::en:AktenNummer)<36";

    /**
     * @param ruleDef RuleDef
     */
    public RuleImplEGFAktennummer(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        try {
            if (XPathFassade.getInstance().evalBool(bmuDok.getDocument().getDocumentElement(), XPATH_AKTENNUMMER)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), 1, null));
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("Es wird geprft, ob das Feld Sonstiges/Aktennumer gefllt ist, wenn das Feld Nachweisnummer ");
        builder.append("EN?XXXXXXXXX oder SN?XXXXXXXXX enthlt, wobei das '?' ");
        builder.append("durch den jeweiligen Landeskenner zu ersetzen ist, oder ob eines der beiden Felder ");
        builder.append("Nachweisnummer oder Sonstiges/Aktennummer gefllt ist (Mindestlnge 36 Zeichen).");
        builder.append(" XPath fr die Prfung: ");
        builder.append(XPATH_AKTENNUMMER);
        return builder.toString();
    }

}
