/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.BMUMessageType;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplLayerATBRolle extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final String[] XPATH_BGS_LAYER_ID = {
            "/descendant::bgs:BGSErgaenzungsLayer[@lib:ATBRolle='BEVERZ' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']" };

    private static final String[] XPATH_ENSN_LAYER_ID = {
            "/descendant::en:ENSNErgaenzungsLayer[@lib:ATBRolle='ZWL' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']" };

    private static final String[] XPATH_UNS_LAYER_ID = {
            "/descendant::bgs:UNSBasisLayer[lib:ATBRolle='ZWL' or @lib:ATBRolle='BEH' or @lib:ATBRolle='BEVERZ' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']",
            "/descendant::bgs:UNSErgaenzungsLayer[@lib:ATBRolle='ZWL' or @lib:ATBRolle='BEVERZ' or @lib:ATBRolle='MAK' or @lib:ATBRolle='PROV' or @lib:ATBRolle='SONST']" };

    private static final Log LOGGER = LogFactory
            .getLog(RuleImplLayerATBRolle.class);

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplLayerATBRolle(RuleDef ruleDef) {
        super(ruleDef);
    }

    private List<RuleResult> checkATBRolle(Document doc, String xPath, int index)
            throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList layerNodeList;
        try {
            layerNodeList = XPathFassade.getInstance()
                    .evaluateNodeList(doc, xPath);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        for (int i = 0; i < layerNodeList.getLength(); i++) {
            Element layer = (Element) layerNodeList.item(i);
            ruleResultList.add(new RuleResultImpl(getRuleDef(), index + i,
                    layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "LayerID")));
        }
        return ruleResultList;
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        Document doc = bmuDok.getDocument();
        BMUMessageType msgType = bmuDok
                .getMessageType();
        int index = 1;
        switch (msgType.getEnumType()) {
        case BGSDokument:
            for (String xPath : XPATH_BGS_LAYER_ID) {
                ruleResultList.addAll(checkATBRolle(doc, xPath, index
                        + ruleResultList.size()));
            }
            break;
        case UNSDokument:
            for (String xPath : XPATH_UNS_LAYER_ID) {
                ruleResultList.addAll(checkATBRolle(doc, xPath, index
                        + ruleResultList.size()));
            }
            break;
        case ENSNDokument:
            for (String xPath : XPATH_ENSN_LAYER_ID) {
                ruleResultList.addAll(checkATBRolle(doc, xPath, index
                        + ruleResultList.size()));
            }
            break;
        default:
            LOGGER.warn("unexpected message-type: " + msgType.getEnumType());
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes fr die Prfung von Begleitscheinen: ");
        builder.append(Arrays.deepToString(XPATH_BGS_LAYER_ID));
        builder.append(RuleImpl.NL);
        builder.append("XPathes fr die Prfung von bernahmescheinen: ");
        builder.append(Arrays.deepToString(XPATH_UNS_LAYER_ID));
        builder.append(RuleImpl.NL);
        builder.append("XPathes fr die Prfung von Nachweisen: ");
        builder.append(Arrays.deepToString(XPATH_ENSN_LAYER_ID));
        return builder.toString();
    }

}
