/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplNamespaceURIFormat extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer lib:Pruefsumme.
     */
    private static final String XPATH_FXS = "/descendant::*[local-name()='FreieXMLStruktur' and @lib:NamespaceURI]";

    /**
     * Format der Namespace-URI in der freien XML-Struktur.
     */
    public static final String REG_EX_URI_FORMAT = "urn:de:bmu:eanv:[a-z0-9_,:=@;!'%/#\\(\\)\\+\\-\\.\\$\\*\\?]{1,}(:[0-9]{1,3}){2}";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplNamespaceURIFormat(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(),
                    XPATH_FXS);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); i++) {
            Element nodeFxs = (Element) nl.item(i);
            String nsURI = nodeFxs.getAttributeNS(Namespace.TypenBibliothek.getUri(), "NamespaceURI");
            String id = nodeFxs.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
            if (nsURI != null && !nsURI.toLowerCase().matches(REG_EX_URI_FORMAT)) {
                ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, id));
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath fr die Ermittlung der freien XML-Strukturen: ");
        builder.append(XPATH_FXS);
        builder.append(", Regulrer Ausdruck fr die Prfung: ");
        builder.append(REG_EX_URI_FORMAT);
        return builder.toString();
    }

}
