/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2021-09-23 10:44:00 +0000 (Thu, 23 Sep 2021) $ $Rev: 1667 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.SchemaValidator;
import de.consist.bmu.rule.schema.SchemaValidator.ValidationErrorHandler;

/**
 * Pruefregel fuer die Schemavalidierung.
 * 
 * @author srossbroich
 * 
 */
public final class RuleImplSchemaValidation extends RuleImpl {

    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RuleImplSchemaValidation.class);
    
    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSchemaValidation(RuleDef ruleDef) {
        super(ruleDef);
    }

    @Override
	public boolean isEnabled(BMUDokument bmuDok) {
   		return false;
	}

	List<RuleResult> executeInternal(Document doc) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        try {
            SchemaValidator validator = SchemaValidator.getInstance();
            ValidationErrorHandler handler = validator.validate(doc.getDocumentElement());
            if (handler != null) {
                List<SAXParseException> errorList = handler.getErrorList();
                if (!errorList.isEmpty()) {
                    for (SAXParseException saxParseException : errorList) {
                        ruleResultList.add(new RuleResultImpl(this.getRuleDef(),
                                index++, saxParseException.getMessage()));
                    }
                }
            } else {
                LOGGER.error("Error validating document");
                throw new BMUException("Error validating document");
            }
        } catch (BMUException e) {
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, e
                    .getMessage()));
        }
        return ruleResultList;
    }
    
    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        return executeInternal(bmuDok.getDocument());
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "Die Schemavalidierung erfolgt mit der DOM3-Implementierung von Xerces-J";
    }
}
