/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 10:24:11 +0200 (Fr, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author candersen
 * 
 */
public final class RuleImplSignatureX509Data extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath zur berprfung auf ein einzelnes X509-Data-Element.
     */
    private static final String XPATH_X509_DATA = "count(descendant::ds:X509Data) > 1";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureX509Data(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        //if (this.getRuleDef().getUseSignatureDate()) {
            NodeList nodeList;
            try {
                nodeList = XPathFassade.getInstance().evaluateNodeList(
                        bmuDok.getDocument(),
                        "/descendant::ds:Signature[@Id]");
            } catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Prfen", e);
            }
            int index = 1;
            for (int i = 0; i < nodeList.getLength(); i++) {
                Node sigNode = nodeList.item(i);
                String sigId = sigNode.getAttributes().getNamedItem("Id")
                        .getTextContent();
                SignatureVerificationResult svr = bmuDok.getMessageType()
                        .getSignatureVerificationResult(sigId);
                if (svr != null && svr.isEnabled(getRuleDef())) {
                    try {
                        if (XPathFassade.getInstance().evalBool(
                                (Element) sigNode,
                                XPATH_X509_DATA)) {
                            ruleResultList.add(new RuleResultImpl(
                                    getRuleDef(), index++, sigId));
                        }
                    } catch (XPathExpressionException e) {
                        throw new BMUException("Fehler beim Prfen", e);
                    }
                }
            }
        //}
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "XPath fr die Prfung: " + XPATH_X509_DATA;
    }

}
