/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 10:24:11 +0200 (Fr, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author candersen
 * 
 */
public final class RuleImplSignatureXadesURI extends RuleImpl {

    private static final long serialVersionUID = 1L;
    
    private static final Log LOGGER = LogFactory.getLog(RuleImplSignatureXadesURI.class);

    /**
     * Liefert true, wenn in keinem Reference-Elemente einer Signatur ein URI-Attribut angegeben ist. 
     */
    private static final String XPATH_XERCES_URI = "count(ds:SignedInfo/ds:Reference[string-length(@URI)>0])=0";
    
    private static final String TECHDOC = "Prft die Xades-Referenz "
            + "(ds:Signature/ds:SignedInfo/ds:Reference) in allen Signaturen "
            + "im Dokument auf die Verwendung eines URI-Attributes.";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureXadesURI(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        XPathFassade xpf = XPathFassade.getInstance();
        //if (this.getRuleDef().getUseSignatureDate()) {
            NodeList nodeList;
            try {
                nodeList = xpf.evaluateNodeList(
                        bmuDok.getDocument(),
                        "/descendant::ds:Signature[@Id]");
	            int index = 1;
	            for (int i = 0; i < nodeList.getLength(); i++) {
	                Node sigNode = nodeList.item(i);
	                String sigId = sigNode.getAttributes().getNamedItem("Id")
	                        .getTextContent();
	                SignatureVerificationResult svr = bmuDok.getMessageType()
	                        .getSignatureVerificationResult(sigId);
	                if (svr != null && svr.isEnabled(getRuleDef())) {
                    	if (xpf.evalBool((Element) sigNode, XPATH_XERCES_URI)) {
                            String msg = "Keine Xades-Reference in der Signatur mit der ID: "
                                    + sigId;
                            LOGGER.debug(msg);
                            ruleResultList
                                    .add(new RuleResultImpl(this
                                            .getRuleDef(), index++,
                                            sigId));
                    	}
	                }
	            }
            } catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Prfen", e);
            }
        //}
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return TECHDOC;
    }

}
