/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;


import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplUNSBefLfdNr extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory.getLog(RuleImplUNSBefLfdNr.class);
    
    /**
     * XPath fuer UNSVorlage-, UNSBasis- und UNSSErgaenzungslayer mit Rolle BEF.
     */
    private static final String[] XPATH_UNS_BEFLFDNR = { "/descendant::bgs:UNSBasisLayer[@lib:ATBRolle='BEF']",
        "/descendant::bgs:UNSErgaenzungsLayer[@lib:ATBRolle='BEF']"
    };

    /**
     * @param ruleDef RuleDef
     */
    public RuleImplUNSBefLfdNr(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        int index = 1;
        for (String xPath : XPATH_UNS_BEFLFDNR) {
            NodeList nl;
            try {
                nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(), xPath);
            } catch (XPathExpressionException e) {
                throw new BMUException("Fehler beim Prfen", e);
            }
            for (int i = 0; i < nl.getLength(); i++) {
                Element layer = (Element) nl.item(i);
                String layerID = layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "LayerID");
                String atbBefLfdNr = layer.getAttributeNS(Namespace.TypenBibliothek.getUri(), "ATBBefLfdNummer");
                if (atbBefLfdNr != null && atbBefLfdNr.length() > 0) {
                    int lfdNr = Integer.parseInt(atbBefLfdNr);
                    if (lfdNr != 1) {
                        ruleResultList.add(new RuleResultImpl(getRuleDef(), index++, layerID));
                    }
                } else {
                    LOGGER.warn("Attribut 'ATBBEfLfdNummer' fehlt.");
                }
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPathes fr die Ermittlung der Layer: ");
        builder.append(Arrays.deepToString(XPATH_UNS_BEFLFDNR));
        return builder.toString();
    }

}
