/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2023-04-01 11:44:40 +0000 (Sat, 01 Apr 2023) $ $Rev: 1752 $
 */
package de.consist.bmu.rule.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Hilfsroutinen fr Datumsobjekte.
 * 
 * @author jannighoefer
 */
public final class DateUtils {
    
    private static final Log LOGGER = LogFactory.getLog(DateUtils.class); 
    
    public static final Date DATE_20150101 = new GregorianCalendar(2015, Calendar.JANUARY, 1).getTime();
    
	private static final String DATE_PATTERN = "dd.MM.yyyy";
	private static final String DATE_TIME_PATTERN = "dd.MM.yyyy HH:mm:ss";
	private static final String DATE_TIME_PATTERN_WITH_MILLIS = "dd.MM.yyyy HH:mm:ss.SSS";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final String TIME_PATTERN_WITHOUT_SECONDS = "HH:mm";

    private DateUtils() {
    }

    /**
     * Erzeugt einen String mit Datum und Zeit im deutschen Format.
     * 
     * @param datum
     *            Der Datumswert
     * @return Der String
     */
    public static String toDateTimeString(Date datum) {
		return toDateTimeString(datum, false);
	}

	/**
	 * Erzeugt einen String mit Datum und Zeit im deutschen Format.
	 * 
	 * @param datum
	 *            Der Datumswert
	 * @return Der String
	 */
	public static String toDateTimeString(Date datum, boolean withMillis) {
		return new SimpleDateFormat(withMillis ? DATE_TIME_PATTERN_WITH_MILLIS : DATE_TIME_PATTERN).format(datum);
    }

    /**
     * Erzeugt einen String mit Datum im deutschen Format.
     * 
     * @param datum
     *            Der Datumswert
     * @return Der String
     */
    public static String toDateString(Date datum) {
		return new SimpleDateFormat(DATE_PATTERN).format(datum);
    }
    
    /**
     * Erzeugt einen String mit der Zeit im deutschen Format.
     * 
     * @param datum
     *            Der Datumswert
     * @return Der String
     */
    public static String toTimeString(Date datum) {
        return toTimeString(datum, true);
    }

    /**
     * Erzeugt einen String mit der Zeit im deutschen Format.
     * 
     * @param datum
     *            Der Datumswert
     * @param withSeconds
     *            Mit Sekunden
     * @return Der String
     */
    public static String toTimeString(Date datum, boolean withSeconds) {
        if (withSeconds) {
            return new SimpleDateFormat(TIME_PATTERN).format(datum);
        } else {
            return new SimpleDateFormat(TIME_PATTERN_WITHOUT_SECONDS).format(datum);
        }
    }

    /**
     * @param dateString Der Datumswert als Zeichenkette
     * @param pattern Das Datumsformat
     * @return Date
     */
    public static Date getDate(String dateString, String pattern) {
        Date date = new Date(0L);
        try {
            date = new SimpleDateFormat(pattern).parse(dateString);
        } catch (ParseException e) {
            LOGGER.warn("Fehler beim parsen: " + dateString + ", pattern=" + pattern, e);
        }
        return date;
    }
    
    public static Date getDateWithoutTime(Date date) {
    	Calendar cal = Calendar.getInstance();
    	cal.setTime(date);
    	cal.set(Calendar.HOUR_OF_DAY, 0);
    	cal.set(Calendar.MINUTE, 0);
    	cal.set(Calendar.SECOND, 0);
    	cal.set(Calendar.MILLISECOND, 0);
    	return cal.getTime();
    }
}
